#include <gtest/gtest.h>

namespace mandelbrot {
extern void mandelbrot(double realCenter, double imagCenter, double width, double height);
}

class TestMandelbrot
    : public ::testing::Test {
    protected:
    void SetUp() override {
        m_stdout = std::tmpfile();
        fflush(stdout);
        std::swap(stdout, m_stdout);
    }

    std::string output(size_t size) {
        fflush(stdout);
        std::swap(stdout, m_stdout);
        std::rewind(m_stdout);
        char* buffer = new char[size];
        memset(buffer, 0, size);
        std::fread(buffer, 1, size, m_stdout);
        std::string s(buffer);
        delete[] buffer;
        return s;
    }

    private:
    std::FILE* m_stdout;
};

//---------------------------------------------------------------------------
TEST_F(TestMandelbrot, Test1) {
    constexpr const char expectedOutput[] =
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                    *                                                                                                   \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                              **                                                                                                        \n"
        "                                                                                         *********                                                                                                      \n"
        "                                                                                         **********                                                                                                     \n"
        "                                                                                          *********                                                                                                     \n"
        "                                                                                            * * **                                                                                                      \n"
        "                                                                         * *     **************************                                                                                             \n"
        "                                                                         **** *********************************  ****                                                                                   \n"
        "                                                                          ******************************************                                                                                    \n"
        "                                                                     * ********************************************                                                                                     \n"
        "                                                                      ***********************************************                                                                                   \n"
        "                                                                  * *****************************************************                                                                               \n"
        "                                                                  *****************************************************                                                                                 \n"
        "                                          ***  ****** *          ******************************************************                                                                                 \n"
        "                                           ****************     *******************************************************                                                                                 \n"
        "                                       **********************  *********************************************************                                                                                \n"
        "                                       *********************** ********************************************************                                                                                 \n"
        "                                 **** *******************************************************************************                                                                                   \n"
        "*****************************************************************************************************************                                                                                       \n"
        "                                 **** *******************************************************************************                                                                                   \n"
        "                                       *********************** ********************************************************                                                                                 \n"
        "                                       **********************  *********************************************************                                                                                \n"
        "                                           ****************     *******************************************************                                                                                 \n"
        "                                          ***  ****** *          ******************************************************                                                                                 \n"
        "                                                                  *****************************************************                                                                                 \n"
        "                                                                  * *****************************************************                                                                               \n"
        "                                                                      ***********************************************                                                                                   \n"
        "                                                                     * ********************************************                                                                                     \n"
        "                                                                          ******************************************                                                                                    \n"
        "                                                                         **** *********************************  ****                                                                                   \n"
        "                                                                         * *     **************************                                                                                             \n"
        "                                                                                            * * **                                                                                                      \n"
        "                                                                                          *********                                                                                                     \n"
        "                                                                                         **********                                                                                                     \n"
        "                                                                                         *********                                                                                                      \n"
        "                                                                                              **                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                    *                                                                                                   \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n"
        "                                                                                                                                                                                                        \n";
    {
        mandelbrot::mandelbrot(0.0, 0.0, 4.0, 3.0);
    }
    ASSERT_EQ(output(sizeof(expectedOutput)), expectedOutput);
}

TEST_F(TestMandelbrot, Test2) {
    constexpr const char expectedOutput[] = "                                                                                                    *                                                                                                   \n"
                                            "                                                                                           *                                                                                                            \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                               *                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                             ***                                                                                                                        \n"
                                            "                                                                         *********                                                                                                                      \n"
                                            "                                                                         *********                                                                                                                      \n"
                                            "                                                                          ********                                                                                                                      \n"
                                            "                                                                     * *******                                                                                                                          \n"
                                            "                                                                 **********************                                                                                                                 \n"
                                            "                                                        ****  ***************************                                                                                                               \n"
                                            "                                                        ***********************************  **                                                                                                         \n"
                                            "                                                           *************************************                                                                                                        \n"
                                            "                                                          ************************************                                                                                                          \n"
                                            "                                                         ***************************************                                                                                                        \n"
                                            "                                                      *****************************************                                                                                                         \n"
                                            "                                                         ************************************* **                                                                                                       \n"
                                            "                                                         **************************************                                                                                                         \n"
                                            "                                                         **************************************                                                                                                         \n"
                                            "                                                          ***********************************                                                                                                           \n"
                                            "                                                           ********************************                                                                                                             \n"
                                            "                                                            *  ***************************                                                                                                              \n"
                                            "                                                                  ******************* *                                                                                                                 \n"
                                            "                                      **                   * **    **    *****     *** *** *                   *                                                                                        \n"
                                            "                        * **   *        ***  ** ********************************************************     ***               *                                                                        \n"
                                            "                          *****    ** ** ************************************************************************         *****                                                                         \n"
                                            "                          ****** ***********************************************************************************     ********                                                                       \n"
                                            "****                  * *  *****************************************************************************************************                                                                        \n"
                                            "*******          **************************************************************************************************************   **                                                                    \n"
                                            "********      * * *****************************************************************************************************************   **                   *****     *                                  \n"
                                            "********    *****************************************************************************************************************************             ******************                                \n"
                                            "*******  ************************************************************************************************************************************        ****************                                   \n"
                                            "***** *****************************************************************************************************************************************    *******************                                  \n"
                                            "**************************************************************************************************************************************************  ******************                                  \n"
                                            "**************************************************************************************************************************************************** ******************                                 \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "*********************************************************************************************************************************************************  ***  *                                       \n"
                                            "***********************************************************************************************************************************************************                                             \n"
                                            "**************************************************************************************************************************************************************                                          \n"
                                            "***************************************************************************************************************************************************************                                         \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "************************************************************************************************************************************************************************                                \n"
                                            "**********************************************************************************************************************************************************************                                  \n"
                                            "***********************************************************************************************************************************************************************                                 \n"
                                            "*************************************************************************************************************************************************************************                               \n"
                                            "*************************************************************************************************************************************************************************         *                     \n"
                                            "*************************************************************************************************************************************************************************** *********                   \n"
                                            "***************************************************************************************************************************************************************************************                 \n"
                                            "*************************************************************************************************************************************************************************************                   \n"
                                            "***************************************************************************************************************************************************************************** **** *                    \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "********************************************************************************************************************************************************************************                        \n"
                                            "********************************************************************************************************************************************************************************     *                  \n"
                                            "*************************************************************************************************************************************************************************************                   \n"
                                            "***************************************************************************************************************************************************************************************                 \n"
                                            "******************************************************************************************************************************************************************************** *                      \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "******************************************************************************************************************************************************************************** *                      \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "**********************************************************************************************************************************************************************************                      \n"
                                            "*****************************************************************************************************************************************************************************                           \n"
                                            "****************************************************************************************************************************************************************************                            \n"
                                            "******************************************************************************************************************************************************************************                          \n"
                                            "**************************************************************************************************************************************************************************                              \n"
                                            "**************************************************************************************************************************************************************************                              \n"
                                            "************************************************************************************************************************************************************************                                \n"
                                            "**********************************************************************************************************************************************************************                                  \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "****************************************************************************************************************************************************************                                        \n"
                                            "*************************************************************************************************************************************************************                                           \n"
                                            "*******************************************************************************************************************************************************                                                 \n"
                                            "*************************************************************************************************************************************************************                                           \n"
                                            "****************************************************************************************************************************************************************                                        \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "**********************************************************************************************************************************************************************                                  \n"
                                            "************************************************************************************************************************************************************************                                \n"
                                            "**************************************************************************************************************************************************************************                              \n"
                                            "**************************************************************************************************************************************************************************                              \n"
                                            "******************************************************************************************************************************************************************************                          \n"
                                            "****************************************************************************************************************************************************************************                            \n"
                                            "*****************************************************************************************************************************************************************************                           \n"
                                            "**********************************************************************************************************************************************************************************                      \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "******************************************************************************************************************************************************************************** *                      \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "******************************************************************************************************************************************************************************** *                      \n"
                                            "***************************************************************************************************************************************************************************************                 \n"
                                            "*************************************************************************************************************************************************************************************                   \n"
                                            "********************************************************************************************************************************************************************************     *                  \n"
                                            "********************************************************************************************************************************************************************************                        \n"
                                            "*********************************************************************************************************************************************************************************                       \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "*******************************************************************************************************************************************************************************                         \n"
                                            "***************************************************************************************************************************************************************************** **** *                    \n"
                                            "*************************************************************************************************************************************************************************************                   \n"
                                            "***************************************************************************************************************************************************************************************                 \n"
                                            "*************************************************************************************************************************************************************************** *********                   \n"
                                            "*************************************************************************************************************************************************************************         *                     \n"
                                            "*************************************************************************************************************************************************************************                               \n"
                                            "***********************************************************************************************************************************************************************                                 \n"
                                            "**********************************************************************************************************************************************************************                                  \n"
                                            "************************************************************************************************************************************************************************                                \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "***************************************************************************************************************************************************************                                         \n"
                                            "**************************************************************************************************************************************************************                                          \n"
                                            "***********************************************************************************************************************************************************                                             \n"
                                            "*********************************************************************************************************************************************************  ***  *                                       \n"
                                            "*******************************************************************************************************************************************************************                                     \n"
                                            "**************************************************************************************************************************************************** ******************                                 \n"
                                            "**************************************************************************************************************************************************  ******************                                  \n"
                                            "***** *****************************************************************************************************************************************    *******************                                  \n"
                                            "*******  ************************************************************************************************************************************        ****************                                   \n"
                                            "********    *****************************************************************************************************************************             ******************                                \n"
                                            "********      * * *****************************************************************************************************************   **                   *****     *                                  \n"
                                            "*******          **************************************************************************************************************   **                                                                    \n"
                                            "****                  * *  *****************************************************************************************************                                                                        \n"
                                            "                          ****** ***********************************************************************************     ********                                                                       \n"
                                            "                          *****    ** ** ************************************************************************         *****                                                                         \n"
                                            "                        * **   *        ***  ** ********************************************************     ***               *                                                                        \n"
                                            "                                      **                   * **    **    *****     *** *** *                   *                                                                                        \n"
                                            "                                                                  ******************* *                                                                                                                 \n"
                                            "                                                            *  ***************************                                                                                                              \n"
                                            "                                                           ********************************                                                                                                             \n"
                                            "                                                          ***********************************                                                                                                           \n"
                                            "                                                         **************************************                                                                                                         \n"
                                            "                                                         **************************************                                                                                                         \n"
                                            "                                                         ************************************* **                                                                                                       \n"
                                            "                                                      *****************************************                                                                                                         \n"
                                            "                                                         ***************************************                                                                                                        \n"
                                            "                                                          ************************************                                                                                                          \n"
                                            "                                                           *************************************                                                                                                        \n"
                                            "                                                        ***********************************  **                                                                                                         \n"
                                            "                                                        ****  ***************************                                                                                                               \n"
                                            "                                                                 **********************                                                                                                                 \n"
                                            "                                                                     * *******                                                                                                                          \n"
                                            "                                                                          ********                                                                                                                      \n"
                                            "                                                                         *********                                                                                                                      \n"
                                            "                                                                         *********                                                                                                                      \n"
                                            "                                                                             ***                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                               *                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                           *                                                                                                            \n";
    {
        mandelbrot::mandelbrot(0.0, 0.0, 1.0, 2.0);
    }
    ASSERT_EQ(output(sizeof(expectedOutput)), expectedOutput);
}

TEST_F(TestMandelbrot, Test3) {
    constexpr const char expectedOutput[] = "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n"
                                            "                                                                                                                                                                                                        \n";
    {
        mandelbrot::mandelbrot(0.5, 0.5, 500.0, 100.0);
    }
    ASSERT_EQ(output(sizeof(expectedOutput)), expectedOutput);
}
//---------------------------------------------------------------------------

int main(int argc, char* argv[]) {
    testing::InitGoogleTest(&argc, argv);
    return RUN_ALL_TESTS();
}
