public class Professor extends Angestellter {
  public enum Rang {
    C1, C2, C3, C4
  }
  
  public Rang rang;
  
  private short lehrstunden;
  private int notenAnzahl;
  private int notenSumme;

  public Professor(int persNr, String name, Rang rang) {
    super(persNr, name);
    this.rang = rang;
  }

  public void leseVorlesung(Vorlesung vorlesung) {
    lehrstunden += vorlesung.sws;
  }

  public short lehrstundenzahl() {
    return lehrstunden;
  }
 
  public void pruefen(Pruefung pruefung) {
    notenAnzahl++;
    notenSumme += pruefung.note;
  }
  
  public float notenschnitt() {
    return (float)notenSumme/notenAnzahl;
  }

  public int gehalt() {
    int gehalt;
    switch (rang) {
      case C1: gehalt = 3000;
      break;
      case C2: gehalt = 3200;
      break;
      case C3: gehalt = 3400;
      break;
      case C4: gehalt = 3600;
      break;
      default: gehalt = 3000;
      break;
    }
    return gehalt;
  }
}