import java.util.ArrayList;

public class Eratosthenes {

   public static void main(String[] args) {
      // Zahlen 2..10000 einfuegen
      ArrayList<Integer> list = new ArrayList<Integer>();
      for (int i = 2; i <= 10000; i++) {
         list.add(i);
      }
      for (Integer zahl : list) {
         // Probiere alle vorherigen Primzahlen als Teiler
         for (Integer teiler : list) {
            // Wenn der zu pruefende Teiler schon groesser als
            // die Quadratwurzel ist , muss es eine Primzahl sein
            if (teiler > Math.sqrt(zahl)) break;
            // Zahlen mit Teiler sind keine Primzahlen und
            // werden daher hier entfernt
            if (zahl % teiler == 0) {
               list.remove(zahl);
               break;
            }
         }
      }
      // Alle verbliebenen Zahlen sind Primzahlen
      for (Integer primzahl : list)
         System.out.println(primzahl);
   }
}
