import db.university.Database;
import db.university.Queries;

import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;


public class DBTest {

    @Before
    public void loadDB() {
        db = Database.LoadDatabase();
    }

    @Test
    public void testQuery1() {
        List<Float> actual = new ArrayList<>();
        Queries.executeQuery1(db, actual);
        List<Float> expected = new ArrayList<>();
        expected.add(7.625f);
        assertEquals(actual, expected);
    }

    @Test
    public void testQuery2() {
        List<String> expected = new ArrayList<>();
        expected.add("Jonas");
        expected.add("Fichte");
        expected.add("Schopenhauer");
        expected.add("Carnap");
        expected.add("Theophrastos");
        expected.add("Feuerbach");

        List<String> results = new ArrayList<>();
        Queries.executeQuery2(db, results);

        // check results
        java.util.Collections.sort(expected);
        java.util.Collections.sort(results);
        assertEquals(expected, results);
    }

    @Test
    public void testQuery3() {
        List<Queries.Query3Result> expected = new ArrayList<>();
        expected.add(new Queries.Query3Result(5216, 1));
        expected.add(new Queries.Query3Result(5041, 2));
        expected.add(new Queries.Query3Result(5043, 0));
        expected.add(new Queries.Query3Result(4052, 1));
        expected.add(new Queries.Query3Result(4630, 0));
        expected.add(new Queries.Query3Result(5001, 4));
        expected.add(new Queries.Query3Result(5049, 1));
        expected.add(new Queries.Query3Result(5259, 1));
        expected.add(new Queries.Query3Result(5052, 1));
        expected.add(new Queries.Query3Result(5022, 2));

        List<Queries.Query3Result> actual = new ArrayList<>();
        Queries.executeQuery3(db, actual);

        java.util.Collections.sort(expected);
        java.util.Collections.sort(actual);
        assertEquals(expected, actual);
    }

    @Test
    public void testQuery4() {
        List<Float> expected = new ArrayList<>();
        expected.add(3f + 2f / 3f);
        List<Float> actual = new ArrayList<>();
        Queries.executeQuery4(db, actual);
        assertEquals(expected, actual);
    }

    private Database db;
}
