package db.university;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Student {
    public Student(int matrNr, String name, int semester) {
        MatrNr = matrNr;
        Name = name;
        Semester = semester;
    }

    public static List<Student> Parse(List<String> lines) {
        List<Student> result = new ArrayList<>();
        for (String line : lines)
            result.add(new Student(line));
        return result;
    }

    private Student(String csv_row) {
        Pattern pattern = Pattern.compile("([0-9]*),(.*),([0-9]*)");
        Matcher matcher = pattern.matcher(csv_row);
        if (matcher.find()) {
            MatrNr = Integer.parseInt(matcher.group(1));
            Name = matcher.group(2);
            Semester = Integer.parseInt(matcher.group(3));
        }
    }



    public int MatrNr;
    public String Name;
    public int Semester;
}