package de.mse.uebung1_extra.dice_game;

public class Player {

   private int id;
   private String name;
   private Dice dice;
   private int points;

   public Player(int id, String name, Dice dice) {
      this.id = id;
      this.name = name;
      this.dice = dice;
      this.points = 0;
   }

   public void doTurn() {
      points += dice.roll();
   }

   public boolean hasWon() {
      return points > 12;
   }

   @Override
   public String toString() {
      return "Player{" +
              "name='" + name + '\'' +
              ", points=" + points +
              '}';
   }

   public String getName() {
      return name;
   }

   public int getId() {
      return id;
   }

   public void reset() {
      points = 0;
   }
}
